*****************************************************
// Data Preparation
*****************************************************

* Append 2014 and 2016 APIS
use "$apisfolder\apis2014ind2.dta", clear
  merge m:1 regn id using "$apisfolder\apis2014hh2.dta", nogen 
  gen year=2014
  recode c12_hgc (0/270 = 1) (280/350 = 2) (380/900 = 3), gen(hgc)
  recode c12_hgc (0/270 280 = 1) (310/350 380 = 2) (410/900 = 3), gen(hgc1)
    label var hgc "highest grade completed"
	label val hgc hgc
	label def hgc 1 "Incomplete Primary" 2 "Incomplete Secondary" 3 "Complete Secondary" 
	
	egen _hhid=group(regn id)
	g flagmed=0
	replace flagmed=1 if medic_products+ medic_outpatient+ medic_inpatient>health	
	*replace health=medic_products+ medic_outpatient+ medic_inpatient if flagmed==1
	

	tempfile apis2014
    save `apis2014', replace


use "$apisfolder\apis2016ind2.dta", clear
  merge m:1 prv mun bgy ea shsn hcn using "$apisfolder\apis2016hh2.dta", nogen 
  
  *destring prv, gen(provcode)
  *merge m:1 provcode using "$data\provreg.dta", nogen
  
  
  gen year=2016
  recode c12_hgc (0/160 191 410/460= 1) (170 180 192 210/240 470/520 = 2) ///
     (250/320 601/940 = 3), gen(hgc)

	
	egen _hhid=group(prv mun bgy ea shsn hcn)	
	append using `apis2014', force
	
	*replace regn=region if regn==.
	
	egen hhid=group(year _hhid)
	
* Generate PHIC membership indicator	
gen phicmem = inlist(1, pphealth03a, pphealth03b)
  label var phicmem "Member of PHIC = 1"
  
* Generate additional variables  
rename c04_sex sex


rename c05_age age
  recode age (80/999 = 80)
recode natpc (1/3 = 1) (4/7 = 2) (8/10 = 3), gen(incg)   
  label var incg "Income group"
  label val incg incg
  label def incg 1 "Low" 2 "Middle" 3 "High"
gen pchealth = health/fsize
  label var pchealth "Per capita health expenditures"
gen lnpchealth = ln(1 + health/fsize)
  label var lnpchealth "Per capita health expenditures, log"
g healthshare=health/totex


egen medic_other=rowtotal(medic_*)  
replace medic_other=health-medic_other

g flagexp=0
replace flagexp=1 if medic_other>0 & medic_other<.
replace flagmed=0 if year==2016

gen pcop=medic_outpatient/fsize
gen pcip=medic_inpatient/fsize
gen pcdrug=medic_products/fsize
gen pcother=medic_other/fsize

gen lnpcop=ln(1+pcop)
gen lnpcip=ln(1+pcip)
gen lnpcdrug=ln(1+pcdrug)
gen lnpcother=ln(1+pcother)


gen D  = (age >= 60)
gen y2016 = (year==2016)
gen D_y2016 = D*y2016
forval lll = 1/5 {
  gen X`lll' = (age - 60)^`lll'
  gen D_X`lll' = D*(age - 60)^`lll'
 }
xi i.hgc i.incg, prefix(d) noomit

g male=sex==1 if sex<.


g yr=year==2016 if year<.
gen D_after=D_y2016

**Corresponds to AT
g categ=1 if (age<60|yr==0) & phicmem==1
**Corresponds to AT+TC
replace categ=2 if age>=60 & phicmem==1 & yr==1
**Corresponds to NT+UC
replace categ=3 if (age<60|yr==0) & phicmem==0
**Corresponds to NT 
replace categ=4 if age>=60 & phicmem==0 & yr==1
label define categ 1 "AlwaysTakers"  2 "AT+TComp" 3 "NT+UComp" 4 "NeverTakers"
label values categ "categ"


*recode regn (1 2 3 5 13 14 41 42 = 1) (6 7 8=2) (9 10 11 12 13 15 16 = 3), gen(isl)

save "$data\apisfile", replace
